local fn = _gn(0xD3A9971CADAC7252)
--- This native draws a box between two vectors in the game world. It is typically used for visualizing boundaries or areas of interest. The color of the box is specified by the red, green, and blue parameters, with alpha determining its opacity. This native should be called every frame for continuous rendering.
-- ```
-- NativeDB Introduced: v323
-- ```
-- @param x1 The x-coordinate of the first corner of the box.
-- @param y1 The y-coordinate of the first corner of the box.
-- @param z1 The z-coordinate of the first corner of the box.
-- @param x2 The x-coordinate of the opposite corner of the box.
-- @param y2 The y-coordinate of the opposite corner of the box.
-- @param z2 The z-coordinate of the opposite corner of the box.
-- @param red The red color component of the box (0 - 255).
-- @param green The green color component of the box (0 - 255).
-- @param blue The blue color component of the box (0 - 255).
-- @param alpha The alpha value of the box (0 - 255).
function Global.DrawBox(x1, y1, z1, x2, y2, z2, red, green, blue, alpha)
	return _in2(fn, x1, y1, z1, x2, y2, z2, red, green, blue, alpha)
end
