local fn = _gn(0xE832D760399EB220)
--- Creates a rope at the specific position, that extends in the specified direction when not attached to any entities.
-- __
-- Rope does NOT interact with anything you attach it to, in some cases it make interact with the world AFTER it breaks (seems to occur if you set the type to -1).
-- Rope will sometimes contract and fall to the ground like you'd expect it to, but since it doesn't interact with the world the effect is just jaring.
-- ```
-- There are 8 different rope types in the base game. Full rope data can be found in `ropedata.xml`.
-- ```cpp
-- enum ePhysicsRopeType {
-- RopeThin = 0, // Verticies: 1, Radius: 0.03, Textures: rope & rope_n
-- RopeWire6 = 1, // Verticies: 4, Radius: 0.015, Textures: steel_cable & steel_cable_n
-- RopeWire32 = 2, // Verticies: 32, Radius: 0.025, Textures: steel_cable & steel_cable_n
-- RopeMesh = 3, // Verticies: 6, Radius: 0.03, Textures: rope & rope_n
-- RopeThinWire32 = 4, // Verticies: 32, Radius: 0.01, Textures: rope & rope_n
-- RopeReins = 5, // Verticies: 32, Radius: 0.005, Textures: rope & rope_n
-- RopeThin4 = 6, // Verticies: 4, Radius: 0.03, Textures: rope & rope_n
-- RopeWire64 = 7 // Verticies: 64, Radius: 0.025, Textures: steel_cable & steel_cable_n
-- }
-- @param x Spawn coordinate X component.
-- @param y Spawn coordinate Y component.
-- @param z Spawn coordinate Z component.
-- @param rotX Rotation X component.
-- @param rotY Rotation Y component.
-- @param rotZ Rotation Z component.
-- @param maxLength The maximum length the rope can droop.
-- @param ropeType The zero-based index of the entry in the `ropedata.xml` file. *NOTE: Using an index which does not exist will crash the game. As of game build 3258, valid values are from `0` to `7` inclusive.*
-- @param initLength The initial length of the rope.
-- @param minLength The minimum length the rope can be.
-- @param lengthChangeRate The speed in which the rope will wind if winding is started.
-- @param collisionOn Whether the rope should have collision. In original scripts this is followed by a LoadRopeData call when set.
-- @param lockFromFront If max length is zero, and this is set to false the rope will become rigid (it will force a specific distance, what ever length is, between the objects).
-- @param timeMultiplier The speed as which physics should run at. 1.0f is normal, 2.0f is twice as fast, -1.0f is time going backwards. This can affect gravity, etc.
-- @param breakable Whether shooting the rope will break it.
-- @param unkPtr Unknown pointer, always 0 in original scrips.
-- @return A script handle for the rope
function Global.AddRope(x, y, z, rotX, rotY, rotZ, maxLength, ropeType, initLength, minLength, lengthChangeRate, onlyPPU, collisionOn, lockFromFront, timeMultiplier, breakable, unkPtr)
	return _in2(fn, x, y, z, rotX, rotY, rotZ, maxLength, ropeType, initLength, minLength, lengthChangeRate, onlyPPU, collisionOn, lockFromFront, timeMultiplier, breakable, _ii(unkPtr) --[[ may be optional ]], _ri)
end
