local fn = _gn(0xC906A7DAB05C8D2B)
--- This native gets the ground level (ground elevation) and returns the Z coordinate that represents it.
-- Note: This native can only calculate the elevation when the coordinates are within the render distance of the client.
-- ```
-- NativeDB Added Parameter 6: BOOL p5
-- ```
-- @param x Position on the X-axis to get ground elevation.
-- @param y Position on the Y-axis to get ground elevation.
-- @param z Position on the Z-axis to get ground elevation.
-- @param includeWater Determines if the top water level at the specified position should be considered the ground elevation. (It would only matter if the specified position is located above or under the water)
-- @return This native\`s first return value (retval) will return true if the ground elevation has been found, and the second (groundZ) will return the z-coord which represents the ground elevation at the specified position.
function Global.GetGroundZFor_3dCoord(x, y, z, includeWater)
	return _in2(fn, x, y, z, _f, includeWater, _r)
end
