local fn = _gn(0xB2A16444EAD9AE47)
--- Will make the ped move to a coordinate while aiming (and optionally shooting) at the given entity.
-- ```cpp
-- enum eFiringPatternHashes {
-- FIRING_PATTERN_DEFAULT = 0,
-- FIRING_PATTERN_BURST_FIRE = -687903391,
-- FIRING_PATTERN_BURST_FIRE_DRIVEBY = -753768974,
-- FIRING_PATTERN_FULL_AUTO = -957453492,
-- FIRING_PATTERN_SINGLE_SHOT = 1566631136,
-- FIRING_PATTERN_DELAY_FIRE_BY_ONE_SEC = 2055493265,
-- FIRING_PATTERN_BURST_FIRE_HELI = -1857128337,
-- FIRING_PATTERN_SHORT_BURSTS = 445831135,
-- FIRING_PATTERN_BURST_FIRE_MICRO = 1122960381,
-- FIRING_PATTERN_SLOW_FIRE_TANK = -490063247,
-- FIRING_PATTERN_TAMPA_MORTAR = -1842093953
-- }
-- ```
-- @param ped Ped to task
-- @param x Destination X position
-- @param y Destination Y position
-- @param z Destination Z position
-- @param entityToAimAt Entity that the ped will aim at.
-- @param moveSpeed Mostly 2f, but also 1/1.2f, etc.
-- @param shoot If true ped will shoot; false - will not
-- @param targetRadius Usually 0.5f
-- @param slowDistance Usually 4f
-- @param navFlags Usually 0 or 64
-- @param firingPattern The firing pattern to use, refer to `eFiringPatternHashes`
-- @param time Usually 20000 (ms)
function Global.TaskGoToCoordWhileAimingAtEntity(ped, x, y, z, entityToAimAt, moveSpeed, shoot, targetRadius, slowDistance, useNavMesh, navFlags, instantBlendAtAim, firingPattern, time)
	return _in2(fn, ped, x, y, z, entityToAimAt, moveSpeed, shoot, targetRadius, slowDistance, useNavMesh, navFlags, instantBlendAtAim, _ch(firingPattern), time)
end
