local fn = _gn(0x659427E0EF36BCDE)
--- All parameters except ped, vehicle, vehicleTarget and speed are optional; with `missionType` being only those that require a target entity.
-- If you don't want to use a parameter; pass `0` for int parameters, and `-1.0f` for the remaining float parameters.
-- ```cpp
-- enum eVehicleMissionType
-- {
-- None = 0,
-- Cruise = 1,
-- Ram = 2,
-- Block = 3,
-- GoTo = 4,
-- Stop = 5,
-- Attack = 6,
-- Follow = 7,
-- Flee = 8,
-- Circle = 9,
-- Escort = 12,
-- GoToRacing = 14,
-- FollowRecording = 15,
-- PoliceBehaviour = 16,
-- Land = 19,
-- LandAndWait = 20,
-- Crash = 21,
-- PullOver = 22,
-- HeliProtect = 23
-- }
-- ```
-- @param ped The ped to be tasked.
-- @param vehicle The vehicles' entity handle.
-- @param vehicleTarget The target vehicle.
-- @param missionType The mission type (default is 0) (see `eVehicleMissionType`).
-- @param speed The speed in m/s.
-- @param drivingStyle The driving style (default is 0) (see [SetDriveTaskDrivingStyle](#\_0xDACE1BE37D88AF67)).
-- @param radius The radius of when the task will be completed (default is -1.0f).
-- @param straightLineDist The distance before the vehicle will drive straight to the target (default is -1.0f).
-- @param DriveAgainstTraffic Whether the vehicle should drive against traffic (default is false).
function Global.TaskVehicleMission(ped, vehicle, vehicleTarget, missionType, speed, drivingStyle, radius, straightLineDist, DriveAgainstTraffic)
	return _in2(fn, ped, vehicle, vehicleTarget, missionType, speed, drivingStyle, radius, straightLineDist, DriveAgainstTraffic)
end
