local fn = _gn(0x2A488C176D52CCA5)
--- Calculates the distance between two points in 3D space. For performance reasons, consider using direct mathematical calculations for distance, as they can be more efficient than calling this native function.
-- ```
-- NativeDB Introduced: v323
-- ```
-- @param x1 X coordinate of the first point.
-- @param y1 Y coordinate of the first point.
-- @param z1 Z coordinate of the first point. Represents the height or elevation at the first point.
-- @param x2 X coordinate of the second point.
-- @param y2 Y coordinate of the second point.
-- @param z2 Z coordinate of the second point. Represents the height or elevation at the second point.
-- @return Returns the distance as a float between the two points (`x1`, `y1`, `z1`) and (`x2`, `y2`, `z2`) in the game world.
function Global.Vdist(x1, y1, z1, x2, y2, z2)
	return _in2(fn, x1, y1, z1, x2, y2, z2, _rf)
end
