local fn = _gn(0x8e51ec29)
--- Override the limits on the number and types of melee combatants. The game is limited to at most ten combatants among the three types: primary, secondary, and observers.
-- This native infers the number of observers based on the primary and secondary counts.
-- @param primaryCount The number of peds that engage in combat (default: 1)
-- @param secondaryCount The number of peds that engage in taunting (default: 3)
-- @param populationPedCount The maximum number of population peds (ambient and scenario) that can engage in combat (default: 3)
function Global.SetPedMeleeCombatLimits(primaryCount, secondaryCount, populationPedCount)
	return _in2(fn, primaryCount, secondaryCount, populationPedCount)
end
