local fn = _gn(0xaaa94d53)
--- Assigns a RadioFX effect to a submix effect slot.
-- The parameter values for this effect are as follows (backticks are used to represent hashes):
-- | Index | Type | Description |
-- |-|-|-|
-- | \`enabled\` | int | Enables or disables RadioFX on this DSP. |
-- | \`default\` | int | Sets default parameters for the RadioFX DSP and enables it. |
-- | \`freq_low\` | float |  |
-- | \`freq_hi\` | float |  |
-- | \`fudge\` | float |  |
-- | \`rm_mod_freq\` | float |  |
-- | \`rm_mix\` | float |  |
-- | \`o_freq_lo\` | float |  |
-- | \`o_freq_hi\` | float |  |
-- @param submixId The submix.
-- @param effectSlot The effect slot for the submix.
function Global.SetAudioSubmixEffectRadioFx(submixId, effectSlot)
	return _in2(fn, submixId, effectSlot)
end
