local fn = _gn(0xEA23C49EAA83ACFB)
--- Revives our local player who was previously dead.
-- **Note:** Call this once you resurrect the player (this does not need to be called every frame).
-- ```cpp
-- enum ePlayerSpawnLocation {
-- // system will decide
-- SPAWN_LOCATION_AUTOMATIC = 0,
-- SPAWN_LOCATION_NEAR_DEATH = 1,
-- SPAWN_LOCATION_NEAR_TEAM_MATES = 2,
-- // script defined area
-- SPAWN_LOCATION_MISSION_AREA = 3,
-- SPAWN_LOCATION_NEAR_OTHER_PLAYERS = 4,
-- SPAWN_LOCATION_NEAR_CURRENT_POSITION = 5,
-- SPAWN_LOCATION_AT_CURRENT_POSITION = 6,
-- SPAWN_LOCATION_NET_TEST_BED = 7,
-- SPAWN_LOCATION_CUSTOM_SPAWN_POINTS = 8,
-- SPAWN_LOCATION_OUTSIDE_SIMEON_GARAGE = 9,
-- SPAWN_LOCATION_NEAR_SPECIFIC_COORDS = 10,
-- SPAWN_LOCATION_AT_SPECIFIC_COORDS = 11,
-- SPAWN_LOCATION_AT_AIRPORT_ARRIVALS = 12,
-- SPAWN_LOCATION_AT_SPECIFIC_COORDS_IF_POSSIBLE = 13,
-- SPAWN_LOCATION_IN_SPECIFIC_ANGLED_AREA = 14,
-- SPAWN_LOCATION_NEAREST_RESPAWN_POINT = 15,
-- SPAWN_LOCATION_AT_SPECIFIC_COORDS_RACE_CORONA = 16,
-- SPAWN_LOCATION_INSIDE_GARAGE = 17,
-- SPAWN_LOCATION_INSIDE_PROPERTY = 18,
-- SPAWN_LOCATION_INSIDE_PROPERTY_OR_GARAGE = 19,
-- SPAWN_LOCATION_NEAR_DEATH_IMPROMPTU = 20,
-- SPAWN_LOCATION_NEAR_CURRENT_POSITION_SPREAD_OUT = 21,
-- SPAWN_LOCATION_NEAREST_RESPAWN_POINT_TO_SPECIFIC_COORDS = 22,
-- SPAWN_LOCATION_NEAREST_HOSPITAL = 23,
-- SPAWN_LOCATION_NEAREST_POLICE_STATION = 24,
-- SPAWN_LOCATION_NEAREST_HOTEL_TO_SPECIFIC_COORDS = 25,
-- SPAWN_LOCATION_MISSION_AREA_NEAR_CURRENT_POSITION = 26,
-- SPAWN_LOCATION_PRIVATE_YACHT = 27,
-- SPAWN_LOCATION_PRIVATE_YACHT_APARTMENT = 28,
-- SPAWN_LOCATION_PRIVATE_FRIEND_YACHT = 29,
-- SPAWN_LOCATION_PRIVATE_YACHT_NEAR_SHORE = 30,
-- SPAWN_LOCATION_NEAR_GANG_BOSS = 31,
-- SPAWN_LOCATION_NEAR_SPECIFIC_COORDS_WITH_GANG = 32,
-- SPAWN_LOCATION_GANG_DM = 33,
-- SPAWN_LOCATION_GANG_BOSS_PRIVATE_YACHT = 34,
-- SPAWN_LOCATION_OFFICE = 35,
-- SPAWN_LOCATION_CLUBHOUSE = 36,
-- SPAWN_LOCATION_NEAR_CURRENT_POSITION_AS_POSSIBLE = 37,
-- SPAWN_LOCATION_NEAR_CURRENT_PERCEIVED_POSITION = 38,
-- SPAWN_LOCATION_IE_WAREHOUSE = 39,
-- SPAWN_LOCATION_BUNKER = 40,
-- SPAWN_LOCATION_HANGAR = 41,
-- SPAWN_LOCATION_DEFUNCT_BASE = 42,
-- SPAWN_LOCATION_NIGHTCLUB = 43,
-- SPAWN_LOCATION_ARENA_GARAGE = 44,
-- SPAWN_LOCATION_CASINO = 45,
-- SPAWN_LOCATION_CASINO_APARTMENT = 46,
-- SPAWN_LOCATION_CASINO_OUTSIDE = 47,
-- SPAWN_LOCATION_ARCADE = 48,
-- SPAWN_LOCATION_CASINO_NIGHTCLUB = 49,
-- SPAWN_LOCATION_SUBMARINE = 50,
-- SPAWN_LOCATION_HEIST_ISLAND_NEAR_DEATH = 51,
-- SPAWN_LOCATION_HEIST_ISLAND_BEACH_PARTY = 52,
-- SPAWN_LOCATION_LAND_NEAR_SUBMARINE = 53,
-- SPAWN_LOCATION_CAR_MEET = 54,
-- SPAWN_LOCATION_AUTO_SHOP = 55,
-- SPAWN_LOCATION_FIXER_HQ = 56,
-- SPAWN_LOCATION_SITTING_SMOKING = 57,
-- SPAWN_LOCATION_DRUNK_WAKE_UP_MUSIC_STUDIO = 58,
-- SPAWN_LOCATION_MUSIC_STUDIO = 59,
-- TOTAL_SPAWN_LOCATIONS = 60
-- };
-- ```
-- ```cpp
-- enum eSpawnReason {
-- SPAWN_REASON_DEATH = 0,
-- SPAWN_REASON_TRANSITION,
-- SPAWN_REASON_MANUAL,
-- SPAWN_REASON_RESTORE_CHARACTER,
-- SPAWN_REASON_IN_VEHICLE
-- };
-- ```
-- ### Added parameters
-- *   **bUnpauseRenderPhases**: This boolean parameter will unpause the render phases when set to `true`.
-- *   **iSpawnLocation**: This integer parameter sets the player's spawn location metric for telemetry. See `ePlayerSpawnLocation` enum.
-- *   **iSpawnReason**: This integer parameter sets the player's spawn reason metric for telemetry. See `eSpawnReason` enum.
-- @param nInvincibilityTime This is the length of time in milliseconds that the player will be invincible for after resurrection.
-- @param bLeaveDeadPed Leaves the dead ped behind when resurrecting.
function Global.NetworkResurrectLocalPlayer(x, y, z, heading, nInvincibilityTime, bLeaveDeadPed)
	return _in2(fn, x, y, z, heading, nInvincibilityTime, bLeaveDeadPed)
end
