local fn = _gn(0xEF0D582CBF2D9B0F)
--- Applies blood damage to a ped with specific parameters for zone, UV offsets, rotation, scale, and initial aging.
-- ```
-- NativeDB Introduced: v323
-- ```
-- @param ped The Ped to which blood damage is applied.
-- @param component Specific component or body part.
-- @param u UV texture coordinates for placing the decal in the specified zone.
-- @param v UV texture coordinates for placing the decal in the specified zone.
-- @param rotation Angle in degrees for the rotation of the blood decal.
-- @param scale Scale factor for the damage, ranging from 0.0 to 1.0.
-- @param forcedFrame Allows a specific frame of damage to be chosen (-1 for random selection).
-- @param preAge Number of seconds to pre-age the damage for an "old wound" effect (0.0 for fresh wound).
-- @param bloodName Name of the blood type, matching an entry in peddamage.xml.
function Global.ApplyPedBloodSpecific(ped, component, u, v, rotation, scale, forcedFrame, preAge, bloodName)
	return _in2(fn, ped, component, u, v, rotation, scale, forcedFrame, preAge, _ts(bloodName))
end
