local fn = _gn(0xDAD029E187A2BEB4)
--- All parameters except ped, heli and speed are optional, with `pedTarget`, `vehicleTarget`, `x`, `y`, `z` being dependent on `missionType` (ie. Attack/Flee mission types require a target ped/vehicle, whereas GoTo mission types require either `x`, `y`, `z` or a target ped/vehicle).
-- If you don't want to use a parameter; pass `0.0f` for `x`, `y` and `z`, `0` for `pedTarget`, `vehicleTarget`, `0` for other int parameters, and `-1.0f` for the remaining float parameters.
-- ```cpp
-- enum eHeliMissionFlags
-- {
-- None = 0,
-- AttainRequestedOrientation = 1,
-- DontModifyOrientation = 2,
-- DontModifyPitch = 4,
-- DontModifyThrottle = 8,
-- DontModifyRoll = 16,
-- LandOnArrival = 32,
-- DontDoAvoidance = 64,
-- StartEngineImmediately = 128,
-- ForceHeightMapAvoidance = 256,
-- DontClampProbesToDestination = 512,
-- EnableTimeslicingWhenPossible = 1024,
-- CircleOppositeDirection = 2048,
-- MaintainHeightAboveTerrain = 4096,
-- IgnoreHiddenEntitiesDuringLand = 8192,
-- DisableAllHeightMapAvoidance = 16384,
-- // ForceHeightMapAvoidance | DontDoAvoidance
-- HeightMapOnlyAvoidance = 320,
-- }
-- ```
-- @param ped The ped to be tasked.
-- @param heli The helicopters' entity handle.
-- @param vehicleTarget The target vehicle (default is 0).
-- @param pedTarget The target ped (default is 0).
-- @param x The x coordinate of the target (default is 0.0f).
-- @param y The y coordinate of the target (default is 0.0f).
-- @param z The z coordinate of the target (default is 0.0f).
-- @param missionType The mission type (default is 0) (see [TaskVehicleMission](#\_0x659427E0EF36BCDE)).
-- @param speed The speed in m/s.
-- @param radius The radius of when the task will be completed (default is -1.0f).
-- @param heading The heading the helicopter will face at task completion (default is -1.0f).
-- @param height The height the helicopter will fly at (default is -1.0f).
-- @param minHeight The height the helicopter will not fly below (default is -1.0f).
-- @param slowDist The distance to the target at which the helicopter will slow down (default is -1.0f).
-- @param missionFlags The mission flags (default is 0) (see `eHeliMissionFlags`).
function Global.TaskHeliMission(ped, heli, vehicleTarget, pedTarget, x, y, z, missionType, speed, radius, heading, height, minHeight, slowDist, missionFlags)
	return _in2(fn, ped, heli, vehicleTarget, pedTarget, x, y, z, missionType, speed, radius, heading, height, minHeight, slowDist, missionFlags)
end
