local fn = _gn(0xFF56381874F82086)
--- Returns data that adheres to the tattoo shop item data that is used in shop_tattoo.meta
-- Character types:
-- ```cpp
-- enum eTattooFaction
-- {
-- TATTOO_SP_MICHAEL = 0,
-- TATTOO_SP_FRANKLIN = 1,
-- TATTOO_SP_TREVOR = 2,
-- TATTOO_MP_FM = 3,
-- TATTOO_MP_FM_F = 4
-- }
-- ```
-- Returned struct properties:
-- ```cpp
-- struct sTattooShopItemValues
-- {
-- // Lock hash, used with IS_CONTENT_ITEM_LOCKED
-- int LockHash;
-- // Unique ID of this slot. It can also be 0.
-- int Index;
-- // Collection hash of this tattoo
-- int CollectionHash;
-- // Preset hash of this tattoo
-- int PresetHash;
-- // Cost of this tattoo in shops.
-- int Cost;
-- // Secondary placement of this tattoo.
-- int eFacing;
-- // Location of this tattoo on the body (for example, for torso there would be chest upper, stomach, etc)
-- int UpdateGroup;
-- // This tattoo's name in the form of a text label.
-- const char* NameTextLabel;
-- };
-- ```
-- @param characterType Which character to get the tattoo data for (Refer to `eTattooFaction` above).
-- @param decorationIndex Tattoo index, value between 0 and [GET_NUM_TATTOO_SHOP_DLC_ITEMS](#\_0x278F76C3B0A8F109).
-- @param outComponent The referenced struct.
-- @return A bool indicating that the tattoo data exists in the files.
function Global.N_0xff56381874f82086(characterType, decorationIndex, outComponent)
	return fn(characterType, decorationIndex, _ii(outComponent) --[[ may be optional ]], _r)
end
