local fn = _gn(0x80CA6A8B6C094CC4)
--- Get the nth closest vehicle node with its heading and total lane count.
-- If you need specific forward and backward lane counts use [GET_CLOSEST_ROAD](#\_0x132F52BBA570FE92)
-- ```cpp
-- enum eNodeFlags {
-- NONE = 0,
-- INCLUDE_SWITCHED_OFF_NODES = 1,
-- INCLUDE_BOAT_NODES = 2,
-- IGNORE_SLIPLANES = 4,
-- IGNORE_SWITCHED_OFF_DEAD_ENDS = 8,
-- }
-- ```
-- @param x x position
-- @param y y position
-- @param z z position
-- @param nthClosest nth closest node
-- @param outPosition returned position of the found node
-- @param heading returned heading of the found node
-- @param totalLanes total lanes (forward + backward) of the found node
-- @param searchFlags Flags used when searching for a node, see `eNodeFlags`
-- @param zMeasureMult How strongly the difference in z direction should be weighted (defaults to 3.0)
-- @param zTolerance How far apart the Z coords have to be before the zMeasureMult kicks in
-- @return Returns `true` if the node was found, or `false` if the node was not found, or was not streamed in.
function Global.GetNthClosestVehicleNodeWithHeading(x, y, z, nthClosest, searchFlags, zMeasureMult, zTolerance)
	return fn(x, y, z, nthClosest, _v, _f, _i, searchFlags, zMeasureMult, zTolerance, _r)
end
