local fn = _gn(0x38B55259C2E078ED)
--- Sets a warning message for one frame with header and upper buttons bit field that don't fit the standard 32 bit set.
-- @param headerTextLabel Text label to set on the header/title.
-- @param line1TextLabel Text label to set on the first line of the body..
-- @param buttonsBitField Bit field of the button flags. See [`SET_WARNING_MESSAGE`](#\_0x7B1776B3B53F8D74).
-- @param buttonsBitFieldUpper Bit field of the upper button flags. See [`SET_WARNING_MESSAGE_WITH_HEADER_AND_SUBSTRING_FLAGS_EXTENDED`](#\_0x15803FEC3B9A872B).
-- @param line2TextLabel Text label to set on the second line of the body.
-- @param addNumber If number should be inserted into `~1~` in the body.
-- @param numberToAdd What number to insert into `~1~` in the body.
-- @param firstSubstring First substring text label to insert into `~a~` in the body.
-- @param secondSubstring Second substring text label to insert into `~a~` in the body.
-- @param showBackground Bool indicating if the message should have a black background.
-- @param errorCode Error number to show at the bottom of the message. `0` is the default.
function Global.SetWarningMessageWithHeaderUnk(headerTextLabel, line1TextLabel, buttonsBitField, buttonsBitFieldUpper, line2TextLabel, addNumber, numberToAdd, firstSubstring, secondSubstring, showBackground, errorCode)
	return fn(_ts(headerTextLabel), _ts(line1TextLabel), buttonsBitField, buttonsBitFieldUpper, _ts(line2TextLabel), addNumber, numberToAdd, _ts(firstSubstring), _ts(secondSubstring), showBackground, errorCode)
end
