local fn = _gn(0xd7664fd1)
--- Registers a key mapping for the current resource.
-- See the related [cookbook post](https://cookbook.fivem.net/2020/01/06/using-the-new-console-key-bindings/) for more information.
-- Below you can find some examples on how to create these keybindings as well as the alternate keybinding syntax, which is preceded by `~!` to indicate that it's an alternate key.
-- @param commandString The command to execute, and the identifier of the binding.
-- @param description A description for in the settings menu.
-- @param defaultMapper The [mapper ID](https://docs.fivem.net/docs/game-references/input-mapper-parameter-ids/) to use for the default binding, e.g. `keyboard`.
-- @param defaultParameter The [IO parameter ID](https://docs.fivem.net/docs/game-references/input-mapper-parameter-ids/) to use for the default binding, e.g. `f3`.
function Global.RegisterKeyMapping(commandString, description, defaultMapper, defaultParameter)
	return fn(_ts(commandString), _ts(description), _ts(defaultMapper), _ts(defaultParameter))
end
