local fn = _gn(0xFCDFF7B72D23A1AC)
--- Checks if entity1 has a clear line of sight to entity2. So a simple raycast which if it collides with any of the given colliderTypes returns false.
-- The direction of the check matters with for example bushes, so checking from inside to outside a bush with traceType 256 returns true, but the other way around returns false.
-- @param entity1 Entity to start from
-- @param entity2 Entity to check to
-- @param flags A bit mask with bits 1, 2, 4, etc, relating to collider types (see: [START_EXPENSIVE_SYNCHRONOUS_SHAPE_TEST_LOS_PROBE](#\_0x377906D8A31E5586)). 17 is most common in GTA scripts.
-- @return Returns `true` if no collider of specified bitmask is hit.
function Global.HasEntityClearLosToEntity(entity1, entity2, flags)
	return fn(entity1, entity2, flags, _r)
end
