local fn = _gn(0x52F357A30698BCCE)
--- Determines if a vehicle is a convertible with an animatable roof. This native checks if the specified vehicle model features a convertible roof that can be lowered or raised through an animation.
-- ```
-- NativeDB Introduced: v323
-- ```
-- @param vehicle The vehicle to check.
-- @param checkRoofExtras When set to `false`, the native checks only for vehicles with an animatable convertible roof. Set to `true` to include additional checks for vehicles that might have a non-animatable roof (i.e., using vehicle extras)
-- @return Returns `true` if the vehicle is a convertible with an animatable roof or if `checkRoofExtras` is `true` and the vehicle has a roof (animatable or not). Returns `false` if the vehicle does not meet the criteria.
function Global.IsVehicleAConvertible(vehicle, checkRoofExtras)
	return fn(vehicle, checkRoofExtras, _r)
end
