local fn = _gn(0x132F52BBA570FE92)
--- Finds an edge (node connection to another node) that satisfies the specified criteria.
-- @param x x position
-- @param y y position
-- @param z z position
-- @param minimumEdgeLength Minimum distance the srcNode must be from the targetNode.
-- @param minimumLaneCount Minimum number of lanes the connection must have.
-- @param srcNode Position of the edge source
-- @param targetNode Position of the edge target
-- @param laneCountForward Lane count forward
-- @param laneCountBackward Lane count backwards
-- @param width Width of gap in middle of road between forward and backward lanes.
-- @param onlyMajorRoads Return major roads only.
-- @return Returns `true` if a road was found, `false` otherwise.
function Global.GetClosestRoad(x, y, z, minimumEdgeLength, minimumLaneCount, onlyMajorRoads)
	return fn(x, y, z, minimumEdgeLength, minimumLaneCount, _v, _v, _i, _i, _f, onlyMajorRoads, _r)
end
