local fn = _gn(0x15C86013127CE63F)
--- All parameters except ped and boat are optional, with `pedTarget`, `vehicleTarget`, `x`, `y`, `z` being dependent on `missionType` (ie. Attack/Flee mission types require a target ped/vehicle, whereas GoTo mission types require either `x`, `y`, `z` or a target ped/vehicle).
-- If you don't want to use a parameter; pass `0.0f` for `x`, `y` and `z`, `0` for `pedTarget`, `vehicleTarget` and other int parameters, and `-1.0f` for the remaining float parameters.
-- ```cpp
-- enum eBoatMissionFlags
-- {
-- None = 0,
-- StopAtEnd = 1,
-- StopAtShore = 2,
-- AvoidShore = 4,
-- PreferForward = 8,
-- NeverStop = 16,
-- NeverNavMesh = 32,
-- NeverRoute = 64,
-- ForceBeached = 128,
-- UseWanderRoute = 256,
-- UseFleeRoute = 512,
-- NeverPause = 1024,
-- // StopAtEnd | StopAtShore | AvoidShore
-- DefaultSettings = 7,
-- // StopAtEnd | StopAtShore | AvoidShore | PreferForward | NeverNavMesh | NeverRoute
-- OpenOceanSettings = 111,
-- // StopAtEnd | StopAtShore | AvoidShore | PreferForward | NeverNavMesh | NeverPause
-- BoatTaxiSettings = 1071,
-- }
-- ```
-- @param ped The ped to be tasked.
-- @param boat The boats' entity handle.
-- @param vehicleTarget The target vehicle (default is 0).
-- @param pedTarget The target ped (default is 0).
-- @param x The x coordinate of the target (default is 0.0f).
-- @param y The y coordinate of the target (default is 0.0f).
-- @param z The z coordinate of the target (default is 0.0f).
-- @param missionType The mission type (default is 0) (see [TaskVehicleMission](#\_0x659427E0EF36BCDE)).
-- @param speed The speed in m/s (default is -1.0f).
-- @param drivingStyle The driving style (default is 0) (see [SetDriveTaskDrivingStyle](#\_0xDACE1BE37D88AF67)).
-- @param radius The radius of when the task will be completed (default is -1.0f).
-- @param missionFlags The mission flags (default is 0) (see `eBoatMissionFlags`).
function Global.TaskBoatMission(ped, boat, vehicleTarget, pedTarget, x, y, z, missionType, speed, drivingStyle, radius, missionFlags)
	return fn(ped, boat, vehicleTarget, pedTarget, x, y, z, missionType, speed, drivingStyle, radius, missionFlags)
end
