local fn = _gn(0x79780fd2)
--- Sets the default number plate text pattern for vehicles seen on the local client with the specified plate index as their *default* index (`plateProbabilities` from carvariations).
-- For consistency, this should be used with the same value on all clients, since vehicles *without* custom text will use a seeded random number generator with this pattern to determine the default plate text.
-- The default value is `11AAA111`, and using this or a NULL string will revert to the default game RNG.
-- ### Pattern string format
-- *   `1` will lead to a random number from 0-9.
-- *   `A` will lead to a random letter from A-Z.
-- *   `.` will lead to a random letter *or* number, with 50% probability of being either.
-- *   `^1` will lead to a literal `1` being emitted.
-- *   `^A` will lead to a literal `A` being emitted.
-- *   Any other character will lead to said character being emitted.
-- *   A string shorter than 8 characters will be padded on the right.
-- @param plateIndex A plate index, or `-1` to set a default for any indices that do not have a specific value.
-- @param pattern A number plate pattern string, or a null value to reset to default.
function Global.SetDefaultVehicleNumberPlateTextPattern(plateIndex, pattern)
	return fn(plateIndex, _ts(pattern))
end
