local fn = _gn(0x80CA6A8B6C094CC4)
--- Get the nth closest vehicle node with its heading and total lane count. If you need specific forward and backward lane counts use [`GET_CLOSEST_ROAD`](#\_0x132F52BBA570FE92).
-- @param x X coordinate
-- @param y Y coordinate
-- @param z Z coordinate
-- @param nthClosest The index of the node to return
-- @param outPosition Pointer to the found nodes coords
-- @param outHeading Pointer to the found nodes heading
-- @param totalLanes Pointer to the total lanes (forward + backward) of the found node
-- @param nodeFlags Node flags, see [`GET_CLOSEST_VEHICLE_NODE`](#\_0x240A18690AE96513)
-- @param zMeasureMult How strongly the difference in the Z direction should be weighted
-- @param zTolerance How far apart the Z coords have to be before `zMeasureMult` kicks in
-- @return Returns `true` if the node was found, or `false` if the node was not found, or was not streamed in.
function Global.GetNthClosestVehicleNodeWithHeading(x, y, z, nthClosest, nodeFlags, zMeasureMult, zTolerance)
	return fn(x, y, z, nthClosest, _v, _f, _i, nodeFlags, zMeasureMult, zTolerance, _r)
end
