local fn = _gn(0x639431E895B9AA57)
--- Check if a entry point for a certain seat is clear, useful for checking if a vehicle seat is accesible.
-- If you park your vehicle near a wall and the ped cannot enter/exit this side, the return value toggles from true (not blocked) to false (blocked).
-- Keep in mind, with checkSide set to true, that only certain vehicles have entry points on both sides for the same seat, like motorcycles, most normal vehicles don't have this and if the native doesn't find a entry point with the given parameters it will always return false. So for most normal usecases leaving checkSide set to false would result in the expected behavior.
-- @param ped The ped to check.
-- @param vehicle The vehicle to check.
-- @param seatIndex See eSeatPosition declared in [`IS_VEHICLE_SEAT_FREE`](#\_0x22AC59A870E6A669).
-- @param checkSide True to check the side of the entry point relative to the vehicle
-- @param leftSide When checkSide is true together with this it only checks if entrypoints on the left side of the vehicle are clear, and for the right side when given false
-- @return True if the entry point is accesible and the area is clear for the given ped.
function Global.IsVehicleSeatAccessible(ped, vehicle, seatIndex, checkSide, leftSide)
	return fn(ped, vehicle, seatIndex, checkSide, leftSide, _r)
end
