local fn = _gn(0x34E710FF01247C5A)
--- Sets the vehicle lights state. Allowing for different lighting modes.
-- ```
-- NativeDB Introduced: v323
-- ```
-- ```cpp
-- enum eVehicleLightSetting {
-- // Normal light behavior. Lights cycle through off, then low beams, then high beams.
-- // Note: It's affected by day or night; high beams don't exist in daytime.
-- NO_VEHICLE_LIGHT_OVERRIDE = 0,
-- // Vehicle doesn't have lights, always off.
-- FORCE_VEHICLE_LIGHTS_OFF  = 1,
-- // Vehicle has always-on lights.
-- // During day: Cycles between low beams and high beams.
-- // At night: Cycles between low beams, low beams, and high beams.
-- FORCE_VEHICLE_LIGHTS_ON   = 2,
-- // Sets vehicle lights on. Behaves like normal lights (same as 0).
-- SET_VEHICLE_LIGHTS_ON     = 3,
-- // Sets vehicle lights off. Behaves like normal lights (same as 0).
-- SET_VEHICLE_LIGHTS_OFF    = 4
-- };
-- ```
-- @param vehicle The target vehicle.
-- @param state A value from `eVehicleLightSetting` representing the desired light setting.
function Global.SetVehicleLights(vehicle, state)
	return fn(vehicle, state)
end
