local fn = _gn(0x49c1f6dc)
--- Registers a keymap that will be triggered whenever `rawKeyIndex` is pressed or released.
-- `onKeyUp` and `onKeyDown` will not provide any arguments.
-- ```ts
-- function onStateChange();
-- ```
-- @param keymapName A **unique** name that the keymap will be bound to, duplicates will result in the keymap not being registered.
-- @param onKeyUp The function to run when the key is no longer being pressed.
-- @param onKeyDown The function to run when the key is being pressed.
-- @param rawKeyIndex The virtual key to bind this keymap to, see a list [here](https://learn.microsoft.com/en-us/windows/win32/inputdev/virtual-key-codes)
-- @param canBeDisabled If calls to [DISABLE_RAW_KEY_THIS_FRAME](#\_0x8BCF0014) will disable this keymap, if a keymap was disabled when the key was pressed down it will still call `onKeyUp` on release.
function Global.RegisterRawKeymap(keymapName, onKeyUp, onKeyDown, rawKeyIndex, canBeDisabled)
	return fn(_ts(keymapName), _mfr(onKeyUp), _mfr(onKeyDown), rawKeyIndex, canBeDisabled)
end
