local fn = _gn(0x7EE9F5D83DD4F90E)
--- Asynchronously starts a line-of-sight (raycast) world probe shape test.
-- ```cpp
-- enum eTraceFlags
-- {
-- None = 0,
-- IntersectWorld = 1,
-- IntersectVehicles = 2,
-- IntersectPeds = 4,
-- IntersectRagdolls = 8,
-- IntersectObjects = 16,
-- IntersectPickup = 32,
-- IntersectGlass = 64,
-- IntersectRiver = 128,
-- IntersectFoliage = 256,
-- IntersectEverything = 511
-- }
-- ```
-- ```cpp
-- enum eTraceOptionFlags
-- {
-- None = 0,
-- OptionIgnoreGlass = 1,
-- OptionIgnoreSeeThrough = 2,
-- OptionIgnoreNoCollision = 4,
-- OptionDefault = 7
-- }
-- ```
-- NOTE: Raycasts that intersect with mission_entites (flag = 2) has limited range and will not register for far away entites. The range seems to be about 30 metres.
-- Use the handle with [GET_SHAPE_TEST_RESULT](#\_0x3D87450E15D98694) or [GET_SHAPE_TEST_RESULT_INCLUDING_MATERIAL](#\_0x65287525D951F6BE) until it returns 0 or 2.
-- @param x1 Starting X coordinate.
-- @param y1 Starting Y coordinate.
-- @param z1 Starting Z coordinate.
-- @param x2 Ending X coordinate.
-- @param y2 Ending Y coordinate.
-- @param z2 Ending Z coordinate.
-- @param traceFlags Refer to `eTraceFlags`, this defines what the shape test will intersect with
-- @param entity An entity to ignore, or 0.
-- @param optionFlags Refer to `eTraceOptionFlags`, this defines additional options for the shape test
-- @return A shape test handle.
function Global.StartShapeTestLosProbe(x1, y1, z1, x2, y2, z2, traceFlags, entity, optionFlags)
	return fn(x1, y1, z1, x2, y2, z2, traceFlags, entity, optionFlags, _ri)
end
