local fn = _gn(0x6B7256074AE34680)
--- This native draws a line between two vectors in the game world. It is typically used for visualizing paths or connections between points. The color of the line is specified by the red, green, and blue parameters, with alpha determining its opacity. This native should be called every frame for continuous rendering.
-- ```
-- NativeDB Introduced: v323
-- ```
-- @param x1 The x-coordinate of the starting point of the line.
-- @param y1 The y-coordinate of the starting point of the line.
-- @param z1 The z-coordinate of the starting point of the line.
-- @param x2 The x-coordinate of the ending point of the line.
-- @param y2 The y-coordinate of the ending point of the line.
-- @param z2 The z-coordinate of the ending point of the line.
-- @param red The red color component of the line (0 - 255).
-- @param green The green color component of the line (0 - 255).
-- @param blue The blue color component of the line (0 - 255).
-- @param alpha The alpha value of the line (0 - 255).
function Global.DrawLine(x1, y1, z1, x2, y2, z2, red, green, blue, alpha)
	return fn(x1, y1, z1, x2, y2, z2, red, green, blue, alpha)
end
