local fn = _gn(0x23703CD154E83B88)
--- Gives the plane a mission (purpose or objective), the mission is passed onto the `iMissionIndex` parameter.
-- ```cpp
-- enum eVehicleMission {
-- MISSION_NONE = 0,
-- MISSION_CRUISE, // 1
-- MISSION_RAM, // 2
-- MISSION_BLOCK, // 3
-- MISSION_GOTO, // 4
-- MISSION_STOP, // 5
-- MISSION_ATTACK, // 6
-- MISSION_FOLLOW, // 7
-- MISSION_FLEE, // 8
-- MISSION_CIRCLE, // 9
-- MISSION_ESCORT_LEFT, // 10
-- MISSION_ESCORT_RIGHT, // 11
-- MISSION_ESCORT_REAR, // 12
-- MISSION_ESCORT_FRONT, // 13
-- MISSION_GOTO_RACING, // 14
-- MISSION_FOLLOW_RECORDING, // 15
-- MISSION_POLICE_BEHAVIOUR, // 16
-- MISSION_PARK_PERPENDICULAR, // 17
-- MISSION_PARK_PARALLEL, // 18
-- MISSION_LAND, // 19
-- MISSION_LAND_AND_WAIT, // 20
-- MISSION_CRASH, // 21
-- MISSION_PULL_OVER, // 22
-- MISSION_PROTECT // 23
-- };
-- ```
-- @param ped The `Ped` handle.
-- @param vehicle The `Vehicle` handle for the actual plane that will be flown.
-- @param targetVehicle The target `Vehicle` handle (in case `eVehicleMission` requires one).
-- @param targetPed The target `Ped` (in case `eVehicleMission` requires one).
-- @param iMissionIndex The mission to be executed. See `eVehicleMission`.
-- @param fCruiseSpeed The cruise speed (in m/s).
-- @param fTargetReachedDist Distance (in meters) (at which the plane thinks it has arrived), this is also used as the hover distance for `MISSION_ATTACK` and `MISSION_CIRCLE`.
-- @param fOrientation Used to specify the desired orientation of the plane in degrees (`0` to `360`). Use `-1` if no specific orientation is required.
-- @param iFlightHeight The height above sea level the plane tries to maintain, i.e. `50` meters.
-- @param iMinHeightAboveTerrain The minimum height above terrain, i.e. `30` meters.
-- @param bPrecise A boolean value, defaults to `true`.
function Global.TaskPlaneMission(ped, vehicle, targetVehicle, targetPed, fTargetCoordX, fTargetCoordY, fTargetCoordZ, iMissionIndex, fCruiseSpeed, fTargetReachedDist, fOrientation, iFlightHeight, iMinHeightAboveTerrain, bPrecise)
	return fn(ped, vehicle, targetVehicle, targetPed, fTargetCoordX, fTargetCoordY, fTargetCoordZ, iMissionIndex, fCruiseSpeed, fTargetReachedDist, fOrientation, iFlightHeight, iMinHeightAboveTerrain, bPrecise)
end
