local fn = _gn(0x45905BE8654AE067)
--- Like [`GET_CLOSEST_VEHICLE_NODE_WITH_HEADING`](#\_0xFF071FB798B803B0), but returns the nth closest node instead of the first.
-- @param x X coordinate
-- @param y Y coordinate
-- @param z Z coordinate
-- @param desiredX The X direction to favour
-- @param desiredY The Y direction to favour
-- @param desiredZ The Z direction to favour
-- @param nthClosest The index of the node to return
-- @param outPosition Pointer to the found nodes coords
-- @param outHeading Pointer to the found nodes heading
-- @param nodeFlags Node flags, see [`GET_CLOSEST_VEHICLE_NODE`](#\_0x240A18690AE96513)
-- @param zMeasureMult How strongly the difference in the Z direction should be weighted
-- @param zTolerance How far apart the Z coords have to be before `zMeasureMult` kicks in
-- @return Returns the nth closest vehicle node with its heading favouring the desired direction.
function Global.GetNthClosestVehicleNodeFavourDirection(x, y, z, desiredX, desiredY, desiredZ, nthClosest, nodeFlags, zMeasureMult, zTolerance)
	return fn(x, y, z, desiredX, desiredY, desiredZ, nthClosest, _v, _f, nodeFlags, zMeasureMult, zTolerance, _r)
end
