local fn = _gn(0xC5F68BE9613E2D18)
--- cpp
-- enum eApplyForceTypes {
-- APPLY_TYPE_FORCE = 0,
-- APPLY_TYPE_IMPULSE = 1,
-- APPLY_TYPE_EXTERNAL_FORCE = 2,
-- APPLY_TYPE_EXTERNAL_IMPULSE = 3,
-- APPLY_TYPE_TORQUE = 4,
-- APPLY_TYPE_ANGULAR_IMPULSE = 5
-- }
-- @param entity The entity handle
-- @param forceType The force type
-- @param x The x component of the force to apply
-- @param y The y component of the force to apply
-- @param z The z component of the force to apply
-- @param offX Offset from center of entity (X)
-- @param offY Offset from center of entity (Y)
-- @param offZ Offset from center of entity (Z)
-- @param nComponent Component of the entity to apply the force too. Only matters for breakable or articulated (ragdoll) physics. 0 means the root or parent component
-- @param bLocalForce Specifies whether the force vector passed in is in local or world coordinates. `true` means the force will get automatically transformed into world space before being applied
-- @param bLocalOffset Specifies whether the offset passed in is in local or world coordinates
-- @param bScaleByMass Specifies whether to scale the force by mass
-- @param bPlayAudio Specifies whether to play audio events related to the force being applied. The audio will depend on the entity type. Currently vehicles are the only entity types supported, and will play a suspension squeal depending on the magnitude of the force
-- @param bScaleByTimeWarp Specifies whether to scale the force by time warp. Default is `true`
function Global.ApplyForceToEntity(entity, forceType, x, y, z, offX, offY, offZ, nComponent, bLocalForce, bLocalOffset, bScaleByMass, bPlayAudio, bScaleByTimeWarp)
	return fn(entity, forceType, x, y, z, offX, offY, offZ, nComponent, bLocalForce, bLocalOffset, bScaleByMass, bPlayAudio, bScaleByTimeWarp)
end
