local fn = _gn(0x149916F50C34A40D)
--- Attaches a camera to a specific bone of a Ped, including full matrix transformations for both rotation and position offsets.
-- This native works with peds only.
-- ```
-- NativeDB Introduced: v1180
-- ```
-- @param cam The camera handle.
-- @param ped The ped handle.
-- @param boneIndex This is different to boneID, use [`GET_PED_BONE_INDEX`](#\_0x3F428D08BE5AAE31) to get the index from the ID. use the index for attaching to specific bones. `cam` will be attached to the center of `ped` if bone index given doesn't correspond to bone indexes for that entity type.
-- @param xRot X-axis rotation.
-- @param yRot Y-axis rotation.
-- @param zRot Z-axis rotation.
-- @param xOffset X-axis offset.
-- @param yOffset Y-axis offset.
-- @param zOffset Z-axis offset.
-- @param isRelative Whether or not the camera position will be relative to the bone rotation.
function Global.AttachCamToPedBone_2(cam, ped, boneIndex, xRot, yRot, zRot, xOffset, yOffset, zOffset, isRelative)
	return fn(cam, ped, boneIndex, xRot, yRot, zRot, xOffset, yOffset, zOffset, isRelative)
end
