local fn = _gn(0x8A97BCA30A0CE478)
--- Hides all objects of the specified model intersecting a sphere centered at (x, y, z) with the given radius.
-- Network players do not see changes done with this.
-- Use [`CREATE_MODEL_HIDE_EXCLUDING_SCRIPT_OBJECTS`](#\_0x3A52AE588830BF7F) if you only want to hide map objects and exclude those created by scripts.
-- Use [`REMOVE_MODEL_HIDE`](#\_0xD9E3006FB3CBD765) to make hidden objects visible again.
-- @param x X Coordinate of the hiding sphere center.
-- @param y Y Coordinate of the hiding sphere center.
-- @param z Z Coordinate of the hiding sphere center.
-- @param radius Radius of the hiding sphere.
-- @param model The object's model hash to hide.
-- @param surviveMapReload If false, only currently loaded objects are hidden. If their map unloads (e.g. by moving away) and reloads, the objects will reappear.
function Global.CreateModelHide(x, y, z, radius, model, surviveMapReload)
	return fn(x, y, z, radius, _ch(model), surviveMapReload)
end
