local fn = _gn(0x5AA3F878A178C4FC)
--- Retrieves the agility for a specific boat model, including any vehicle mods. Unlike other vehicles where Rockstar Games typically assess performance based on traction, boats use agility as a measure. This static value is distinct from the traction metrics used for other vehicle types.
-- ```
-- NativeDB Introduced: v323
-- ```
-- @param modelHash The model hash of the boat.
-- @return Returns the agility value of the specified boat as a float number.
function Global.GetVehicleModelMoveResistance(modelHash)
	return fn(_ch(modelHash), _rf)
end
