local fn = _gn(0xff44780e)
--- Allows drawing advanced light effects, known as coronas, which support flares, volumetric lighting, and customizable glow properties.
-- @param posX The X position of the corona origin.
-- @param posY The Y position of the corona origin.
-- @param posZ The Z position of the corona origin.
-- @param size The size of the corona.
-- @param red The red component of the marker color, on a scale from 0-255.
-- @param green The green component of the marker color, on a scale from 0-255.
-- @param blue The blue component of the marker color, on a scale from 0-255.
-- @param alpha The alpha component of the marker color, on a scale from 0-255.
-- @param intensity The intensity of the corona.
-- @param zBias zBias slightly shifts the depth of surfaces to make sure they don’t overlap or cause visual glitches when they are very close together. The zBias value are usually in the range of 0.0 to 1.0.
-- @param dirX The X direction of the corona.
-- @param dirY The Y direction of the corona.
-- @param dirZ The Z direction of the corona.
-- @param viewThreshold The view threshold is to determine the fading of the corona based on the distance.
-- @param innerAngle The inner angle of the corona.
-- @param outerAngle The outer angle of the corona.
-- @param flags The corona flags.
function Global.DrawCorona(posX, posY, posZ, size, red, green, blue, alpha, intensity, zBias, dirX, dirY, dirZ, viewThreshold, innerAngle, outerAngle, flags)
	return fn(posX, posY, posZ, size, red, green, blue, alpha, intensity, zBias, dirX, dirY, dirZ, viewThreshold, innerAngle, outerAngle, flags)
end
