local fn = _gn(0x29280002282F1928)
--- This native draws a textured polygon between three vectors in the game world. It's commonly utilized for rendering deadline trailing lights, with additional details available in the `deadline.ytd` file. UVW mapping details (u,v,w parameters) can be found on various internet resources. This native is specifically used for drawing textured polygons on the screen, where UV coordinates define the texture mapping and color/alpha parameters define the appearance of the polygon. This native should be called every frame for continuous rendering.
-- ```
-- NativeDB Introduced: v877
-- ```
-- @param x1 The x-coordinate of the first vector.
-- @param y1 The y-coordinate of the first vector.
-- @param z1 The z-coordinate of the first vector.
-- @param x2 The x-coordinate of the second vector.
-- @param y2 The y-coordinate of the second vector.
-- @param z2 The z-coordinate of the second vector.
-- @param x3 The x-coordinate of the third vector.
-- @param y3 The y-coordinate of the third vector.
-- @param z3 The z-coordinate of the third vector.
-- @param red The red color component of the polygon (0 - 255).
-- @param green The green color component of the polygon (0 - 255).
-- @param blue The blue color component of the polygon (0 - 255).
-- @param alpha The alpha value of the polygon (0 - 255).
-- @param textureDict The name of the texture dictionary.
-- @param textureName The name of the texture.
-- @param u1 The u-coordinate of the first UV mapping.
-- @param v1 The v-coordinate of the first UV mapping.
-- @param w1 The w-coordinate of the first UV mapping.
-- @param u2 The u-coordinate of the second UV mapping.
-- @param v2 The v-coordinate of the second UV mapping.
-- @param w2 The w-coordinate of the second UV mapping.
-- @param u3 The u-coordinate of the third UV mapping.
-- @param v3 The v-coordinate of the third UV mapping.
-- @param w3 The w-coordinate of the third UV mapping.
function Global.DrawTexturedPoly(x1, y1, z1, x2, y2, z2, x3, y3, z3, red, green, blue, alpha, textureDict, textureName, u1, v1, w1, u2, v2, w2, u3, v3, w3)
	return fn(x1, y1, z1, x2, y2, z2, x3, y3, z3, red, green, blue, alpha, _ts(textureDict), _ts(textureName), u1, v1, w1, u2, v2, w2, u3, v3, w3)
end
