local fn = _gn(0xDC0F817884CDD856)
--- Enables or disables the specified 'dispatch service' type. 'Dispatch services' are used for spawning AI response peds/vehicles for events such as a fire in the street (type 3 - DT_FireDepartment), or gunfire in a gang area (type 11 - DT_Gangs).
-- List of dispatch services:
-- ```cpp
-- enum eDispatchType
-- {
-- DT_Invalid = 0,
-- DT_PoliceAutomobile = 1,
-- DT_PoliceHelicopter = 2,
-- DT_FireDepartment = 3,
-- DT_SwatAutomobile = 4,
-- DT_AmbulanceDepartment = 5,
-- DT_PoliceRiders = 6,
-- DT_PoliceVehicleRequest = 7,
-- DT_PoliceRoadBlock = 8,
-- DT_PoliceAutomobileWaitPulledOver = 9,
-- DT_PoliceAutomobileWaitCruising = 10,
-- DT_Gangs = 11,
-- DT_SwatHelicopter = 13,
-- DT_PoliceBoat = 14,
-- DT_ArmyVehicle = 15,
-- DT_BikerBackup = 15
-- };
-- ```
-- Note that 'dispatch service' has nothing to do with the police scanner (audio), to toggle that, use [SET_AUDIO_FLAG](#\_0xB9EFD5C25018725A) with `'PoliceScannerDisabled'`.
-- @param dispatchService The ID of the dispatch service to toggle.
-- @param toggle True to enable the dispatch service, false to disable the dispatch service.
function Global.EnableDispatchService(dispatchService, toggle)
	return fn(dispatchService, toggle)
end
