local fn = _gn(0xdffba12f)
--- ### Supported types
-- *   \[1] : Peds (including animals) and players.
-- *   \[2] : Vehicles.
-- *   \[3] : Objects (props), doors, and projectiles.
-- ### Coordinates need to be send unpacked (x,y,z)
-- ```lua
-- -- Define the allowed model hashes
-- local allowedModelHashes = { GetHashKey("p_crate03x"), GetHashKey("p_crate22x") }
-- -- Get the player's current coordinates
-- local playerCoords = GetEntityCoords(PlayerPedId())
-- -- Retrieve all entities of type Object (type 3) within a radius of 10.0 units
-- -- that match the allowed model hashes
-- -- and sort output entities by distance
-- local entities = GetEntitiesInRadius(playerCoords.x, playerCoords.y, playerCoords.z, 10.0, 3, true, allowedModelHashes)
-- -- Iterate through the list of entities and print their ids
-- for i = 1, #entities do
-- local entity = entities[i]
-- print(entity)
-- end
-- ```
-- @param x The X coordinate.
-- @param y The Y coordinate.
-- @param z The Z coordinate.
-- @param radius Max distance from coordinate to entity
-- @param entityType Entity types see list below
-- @param sortByDistance Sort output entites by distance from nearest to farthest
-- @param models List of allowed models its also optional
-- @return An array containing entity handles for each entity.
function Global.GetEntitiesInRadius(x, y, z, radius, entityType, sortByDistance, models)
	local models_bytes, models_len = _obj(models)
	return fn(x, y, z, radius, entityType, sortByDistance, models_bytes, models_len, _ro)
end
