local fn = _gn(0x20B60995556D004F)
--- Checks if the entity is within the given square of size xSize, ySize, zSize centered around the given coordinates.
-- The sizes given are the apothem (half of side) of the square, so a size of 5 would result in a square of 10x10, not 5x5.
-- For the highlightArea, if do3dCheck is true, the marker will be drawn at the bottom of the target area. So if the square is centered on the ground with a zSize larger than 0, the marker will appear under the ground.
-- The marker also doesn't scale, so it is always the same size (around half a meter).
-- So unfortunately the marker isn't that useful as it doesn't convey the correct information about the area (the marker doesn't reflect when the player is actually in the marker or not)
-- @param entity The entity to check the position of
-- @param xPos The position of the square along the x-axis
-- @param yPos The position of the square along the y-axis
-- @param zPos The position of the square along the z-axis (only applicable if do3dCheck is true)
-- @param xSize The apothem of the square along the x-axis
-- @param ySize The apothem of the square along the y-axis
-- @param zSize The apothem of the square along the z-axis (only applicable if do3dCheck is true)
-- @param highlightArea Whether to draw a marker (yellow cylindrical marker at the given coords)
-- @param do3dCheck Whether to check the z-axis
-- @param transportMode Checks the transport mode the ped is using, only does something if entity is a ped. Transport modes are: 0 (any), 1 (on foot), 2 (in vehicle)
-- @return A boolean value which represents if the entity is within the given square area.
function Global.IsEntityAtCoord(entity, xPos, yPos, zPos, xSize, ySize, zSize, highlightArea, do3dCheck, transportMode)
	return fn(entity, xPos, yPos, zPos, xSize, ySize, zSize, highlightArea, do3dCheck, transportMode, _r)
end
