local fn = _gn(0x825dc0d1)
--- Sets the volumes for the sound channels in a submix effect.
-- Values can be between 0.0 and 1.0.
-- Channel 5 and channel 6 are not used in voice chat but are believed to be center and LFE channels.
-- Output slot starts at 0 for the first ADD_AUDIO_SUBMIX_OUTPUT call then incremented by 1 on each subsequent call.
-- @param submixId The submix.
-- @param outputSlot The output slot index.
-- @param frontLeftVolume The volume for the front left channel.
-- @param frontRightVolume The volume for the front right channel.
-- @param rearLeftVolume The volume for the rear left channel.
-- @param rearRightVolume The volume for the rear right channel.
-- @param channel5Volume The volume for channel 5.
-- @param channel6Volume The volume for channel 6.
function Global.SetAudioSubmixOutputVolumes(submixId, outputSlot, frontLeftVolume, frontRightVolume, rearLeftVolume, rearRightVolume, channel5Volume, channel6Volume)
	return fn(submixId, outputSlot, frontLeftVolume, frontRightVolume, rearLeftVolume, rearRightVolume, channel5Volume, channel6Volume)
end
