local fn = _gn(0x83CDB10EA29B370B)
--- Similar in functionality to [`TASK_PLAY_ANIM`](#\_0xEA47FE3719165B94), except the position and rotation parameters let you specify the initial position and rotation of the task. The ped is teleported to the position specified.
-- [Animations list](https://alexguirre.github.io/animations-list/)
-- @param ped The ped you want to play the animation
-- @param animDictionary The animation dictionary
-- @param animationName The animation name
-- @param posX Initial X position of the task
-- @param posY Initial Y position of the task
-- @param posZ Initial Z position of the task
-- @param rotX Initial X rotation of the task
-- @param rotY Initial Y rotation of the task
-- @param rotZ Initial Z rotation of the task
-- @param blendInSpeed The speed at which the animation blends in. Lower is slower and higher is faster, 1.0 is normal, 8.0 is basically instant
-- @param blendOutSpeed The speed at which the animation blends out. Lower is slower and higher is faster, 1.0 is normal, 8.0 is basically instant
-- @param duration The duration of the animation in milliseconds. -1 will play the animation until canceled
-- @param flag See [`TASK_PLAY_ANIM`](#\_0xEA47FE3719165B94)
-- @param animTime Value between 0.0 and 1.0, lets you start an animation from the given point
function Global.TaskPlayAnimAdvanced(ped, animDictionary, animationName, posX, posY, posZ, rotX, rotY, rotZ, blendInSpeed, blendOutSpeed, duration, flag, animTime, p14, p15)
	return fn(ped, _ts(animDictionary), _ts(animationName), posX, posY, posZ, rotX, rotY, rotZ, blendInSpeed, blendOutSpeed, duration, flag, animTime, p14, p15)
end
