local fn = _gn(0x6DD05E9D83EFA4C9)
--- Creates a gamer tag for the specified local player ID, automatically attached to the player's current ped.
-- The created gamer tag will have the same ID as the player. You can use [IS_MP_GAMER_TAG_ACTIVE](#\_0x4E929E7A5796FD26) to check if a gamer tag already exists for a player.
-- After the gamer tag is created, all components will be set as invisible. Use [SET_MP_GAMER_TAG_VISIBILITY](#\_0x63BB75ABEDC1F6A0) to change the visibility of individual components or [\_SET_MP_GAMER_TAG_VISIBILITY_ALL](#\_0xEE76FF7E6A0166B0) to set all of them at once.
-- To create a gamer tag for a ped that is not a player, see [CREATE_FAKE_MP_GAMER_TAG](#\_0xBFEFE3321A3F5015).
-- @param player The local player ID to assign the gamer tag to.
-- @param username The name displayed on the gamer tag.
-- @param crewIsPrivate If the crew is private. Public crews have a pointed end cap, private crews do not.
-- @param crewIsRockstar If the crew is a Rockstar crew. Rockstar crews include a Rockstar logo before the name.
-- @param crewName The name of the crew.
-- @param crewRank The rank from 1-5 that the player is within the crew. Use 0 if the player is the founder of the crew. Only relevant for private crews.
-- @param crewR Red component of the crew colour.
-- @param crewG Green component of the crew colour.
-- @param crewB Blue component of the crew colour.
function Global.CreateMpGamerTagWithCrewColor(player, username, crewIsPrivate, crewIsRockstar, crewName, crewRank, crewR, crewG, crewB)
	return fn(player, _ts(username), crewIsPrivate, crewIsRockstar, _ts(crewName), crewRank, crewR, crewG, crewB)
end
