local fn = _gn(0x2ba40795)
--- Sets a handling override for a specific vehicle. Certain handling flags can only be set globally using `SET_HANDLING_FIELD`, this might require some experimentation.
-- Example: `SetVehicleHandlingField(vehicle, 'CHandlingData', 'fSteeringLock', 360.0)`
-- @param vehicle The vehicle to set data for.
-- @param class_ The handling class to set. Only "CHandlingData" is supported at this time.
-- @param fieldName The field name to set. These match the keys in `handling.meta`.
-- @param value The value to set.
function Global.SetVehicleHandlingField(vehicle, class_, fieldName, value)
	return fn(vehicle, _ts(class_), _ts(fieldName), value)
end
