local fn = _gn(0x3317DEDB88C95038)
--- Determines if a ped is dead. Contrary to what the name might suggest, it does not always detect when a ped is in the 'dying' phase (transitioning to death). The exception is when `checkMeleeDeathFlags` is set to `true`, which then includes peds in the midst of melee takedown moves as being in a dying state, even if the death task has not yet started.
-- ```
-- NativeDB Introduced: v323
-- ```
-- @param ped The ped to check.
-- @param checkMeleeDeathFlags If set to `true`, extends the check to include melee takedown moves as part of the dying phase.
-- @return Returns `true` if the ped is dead. When `checkMeleeDeathFlags` is set to `true`, it also considers peds in melee takedown moves as dying, although the broader 'dying' phase may not be detected.
function Global.IsPedDeadOrDying(ped, checkMeleeDeathFlags)
	return fn(ped, checkMeleeDeathFlags, _r)
end
