local fn = _gn(0x7f9d543)
--- Sets a global handling override for a specific vehicle class. The name is supposed to match the `handlingName` field from handling.meta.
-- Example: `SetHandlingVector('AIRTUG', 'CHandlingData', 'vecCentreOfMassOffset', vector3(0.0, 0.0, -5.0))`
-- @param vehicle The vehicle class to set data for.
-- @param class_ The handling class to set. Only "CHandlingData" is supported at this time.
-- @param fieldName The field name to set. These match the keys in `handling.meta`.
-- @param value The Vector3 value to set.
function Global.SetHandlingVector(vehicle, class_, fieldName, value)
	return fn(_ts(vehicle), _ts(class_), _ts(fieldName), value)
end
