local fn = _gn(0xC32779C16FCEECD9)
--- Sets the IK target for a given IK part belonging to the ped.
-- **Please note:** The IK target will only be valid for one update, so it needs to be set for as long as it is needed (to avoid IK targets not being cleared and getting stuck enabled).
-- ```cpp
-- enum eIkPart {
-- IK_PART_INVALID = 0,
-- // head
-- IK_PART_HEAD = 1,
-- // spine
-- IK_PART_SPINE = 2,
-- // Left Arm
-- IK_PART_ARM_LEFT = 3,
-- // Right Arm
-- IK_PART_ARM_RIGHT = 4,
-- // Left Leg
-- IK_PART_LEG_LEFT = 5,
-- // Right Leg
-- IK_PART_LEG_RIGHT = 6
-- };
-- ```
-- ```cpp
-- enum eIkTargetFlags {
-- ITF_DEFAULT = 0,
-- // arm target relative to the handbone
-- ITF_ARM_TARGET_WRT_HANDBON = 1,
-- // arm target relative to the pointhelper
-- ITF_ARM_TARGET_WRT_POINTHELPER = 2,
-- // arm target relative to the ikhelper
-- ITF_ARM_TARGET_WRT_IKHELPE = 4,
-- // use animation tags directly
-- ITF_IK_TAG_MODE_NORMAL = 8,
-- // use animation tags in ALLOW mode
-- ITF_IK_TAG_MODE_ALLOW = 16,
-- // use animation tags in BLOCK mode
-- ITF_IK_TAG_MODE_BLOCK = 32,
-- // solve for orientation in addition to position
-- ITF_ARM_USE_ORIENTATION = 64
-- };
-- ```
-- ```
-- NativeDB Introduced: v323
-- ```
-- @param ped The ped handle.
-- @param ikIndex See `eIkPart` for indexes.
-- @param entityLookAt Set to 0 for no entity, offsets will be world coordinates instead.
-- @param boneLookAt Set to -1 for no target bone.
-- @param offsetX X-axis offset calculated from the position of `entityLookAt`.
-- @param offsetY Y-axis offset calculated from the position of `entityLookAt`.
-- @param offsetZ Z-axis offset calculated from the position of `entityLookAt`.
-- @param ikTargetFlags See `eIkTargetFlags` for flags.
-- @param blendInDuration Animation blending in (in ms). `-1` by default.
-- @param blendOutDuration Animation blending out (in ms). `-1` by default.
function Global.SetIkTarget(ped, ikIndex, entityLookAt, boneLookAt, offsetX, offsetY, offsetZ, ikTargetFlags, blendInDuration, blendOutDuration)
	return fn(ped, ikIndex, entityLookAt, boneLookAt, offsetX, offsetY, offsetZ, ikTargetFlags, blendInDuration, blendOutDuration)
end
