local fn = _gn(0xF78F94D60248C737)
--- Queries whether the control panels of a plane are intact. This native is used to determine the operational status of a plane's cockpit controls, which can affect the plane's flyability.
-- @param vehicle The vehicle to check. This should be a plane.
-- @param checkForZeroHealth If set to `true`, the native also checks if the plane's health is zero, indicating it is completely destroyed. If `false`, only the state of the control panels is considered.
-- @return Returns `true` if the plane's control panels are intact, and, depending on the `checkForZeroHealth` parameter, the plane is not completely destroyed. Returns `false` if the control panels are damaged or the plane is destroyed (when `checkForZeroHealth` is `true`).
function Global.N_0xf78f94d60248c737(vehicle, checkForZeroHealth)
	return fn(vehicle, checkForZeroHealth, _r)
end
