local fn = _gn(0x2A70BAE8883E4C81)
--- An **angled area** is an X-Z oriented rectangle with three parameters:
-- 1.  **origin**: the mid-point along a base edge of the rectangle;
-- 2.  **extent**: the mid-point of opposite base edge on the other Z;
-- 3.  **width**: the length of the base edge; (named derived from logging strings `CNetworkRoadNodeWorldStateData`).
-- The oriented rectangle can then be derived from the direction of the two points (`norm(origin - extent)`), its orthonormal, and the width, e.g:
-- 1.  [golf_mp](https://i.imgur.com/JhsQAK9.png)
-- 2.  [am_taxi](https://i.imgur.com/TJWCZaT.jpg)
-- @param xPos The x coordinate.
-- @param yPos The y coordinate.
-- @param zPos The z coordinate.
-- @param x1 X dimension of the angled area 'origin'
-- @param y1 Y dimension of the angled area 'origin'
-- @param z1 Z dimension of the angled area 'origin'
-- @param x2 X dimension of the angled area 'extent'
-- @param y2 Y dimension of the angled area 'extent'
-- @param z2 Z dimension of the angled area 'extent'
-- @param width Width of the angled area
-- @param p10 a debug flag invoking functions in the same path as `DRAW_MARKER`
-- @param includez If true, include the Z dimension when doing the height check; otherwise the query becomes two-dimensional
function Global.IsPointInAngledArea(xPos, yPos, zPos, x1, y1, z1, x2, y2, z2, width, p10, includez)
	return fn(xPos, yPos, zPos, x1, y1, z1, x2, y2, z2, width, p10, includez, _r)
end
