local fn = _gn(0x28477EC23D892089)
--- Draws a marker with the specified appearance at the target location. This has to be called every frame, e.g. in a `Wait(0)` loop.
-- There's a [list of markers](https://docs.fivem.net/game-references/markers/) on the FiveM documentation site.
-- @param type The marker type to draw.
-- @param posX The X coordinate to draw the marker at.
-- @param posY The Y coordinate to draw the marker at.
-- @param posZ The Z coordinate to draw the marker at.
-- @param dirX The X component of the direction vector for the marker, or 0.0 to use rotX/Y/Z.
-- @param dirY The Y component of the direction vector for the marker, or 0.0 to use rotX/Y/Z.
-- @param dirZ The Z component of the direction vector for the marker, or 0.0 to use rotX/Y/Z.
-- @param rotX The X rotation for the marker. Only used if the direction vector is 0.0.
-- @param rotY The Y rotation for the marker. Only used if the direction vector is 0.0.
-- @param rotZ The Z rotation for the marker. Only used if the direction vector is 0.0.
-- @param scaleX The scale for the marker on the X axis.
-- @param scaleY The scale for the marker on the Y axis.
-- @param scaleZ The scale for the marker on the Z axis.
-- @param red The red component of the marker color, on a scale from 0-255.
-- @param green The green component of the marker color, on a scale from 0-255.
-- @param blue The blue component of the marker color, on a scale from 0-255.
-- @param alpha The alpha component of the marker color, on a scale from 0-255.
-- @param bobUpAndDown Whether or not the marker should slowly animate up/down.
-- @param faceCamera Whether the marker should be a 'billboard', as in, should constantly face the camera.
-- @param p19 Typically set to `2`. Does not seem to matter directly.
-- @param rotate Rotations only apply to the heading.
-- @param textureDict A texture dictionary to draw the marker with, or NULL. Example: 'GolfPutting'
-- @param textureName A texture name in `textureDict` to draw the marker with, or NULL. Example: 'PuttingMarker'
-- @param drawOnEnts Whether or not the marker should draw on intersecting entities.
function Global.DrawMarker(type, posX, posY, posZ, dirX, dirY, dirZ, rotX, rotY, rotZ, scaleX, scaleY, scaleZ, red, green, blue, alpha, bobUpAndDown, faceCamera, p19, rotate, textureDict, textureName, drawOnEnts)
	return _in2(fn, type, posX, posY, posZ, dirX, dirY, dirZ, rotX, rotY, rotZ, scaleX, scaleY, scaleZ, red, green, blue, alpha, bobUpAndDown, faceCamera, p19, rotate, _ts(textureDict), _ts(textureName), drawOnEnts)
end
