local fn = _gn(0x867654CBC7606F2C)
--- Shoots a bullet from the first vector to the second vector. The weapon used as weaponHash should already be loaded via REQUEST_WEAPON_ASSET, otherwise the bullet may fail to materialise.
-- @param x1 The X coordinate to start the shot at.
-- @param y1 The Y coordinate to start the shot at.
-- @param z1 The Z coordinate to start the shot at.
-- @param x2 The X coordinate the shot should end up at.
-- @param y2 The Y coordinate the shot should end up at.
-- @param z2 The Z coordinate the shot should end up at.
-- @param damage The amount of damage the bullet carries.
-- @param pureAccuracy Whether the bullet should have pinpoint accuracy.
-- @param weaponHash Hash of the weapon the bullet is used as ammunition for.
-- @param ownerPed Owner of the bullet, e.g. if the bullet kills someone the kill feed shows 'X was shot by ownerPed.'
-- @param isAudible Whether the bullet should be audible. Optional, defaults to true
-- @param isInvisible Whether the bullet should be invisible. Optional, defaults to false
-- @param speed Speed the bullet should fly at. Optional
function Global.ShootSingleBulletBetweenCoords(x1, y1, z1, x2, y2, z2, damage, pureAccuracy, weaponHash, ownerPed, isAudible, isInvisible, speed)
	return _in2(fn, x1, y1, z1, x2, y2, z2, damage, pureAccuracy, _ch(weaponHash), ownerPed, isAudible, isInvisible, speed)
end
