local fn = _gn(0x0134F0835AB6BFCB)
--- ```
-- Creates a checkpoint. Returns the handle of the checkpoint.
-- 20/03/17 : Attention, checkpoints are already handled by the game itself, so you must not loop it like markers.
-- Parameters:
-- * type - The type of checkpoint to create. See below for a list of checkpoint types.
-- * pos1 - The position of the checkpoint.
-- * pos2 - The position of the next checkpoint to point to.
-- * diameter - The diameter of the checkpoint.
-- * color - The color of the checkpoint.
-- * reserved - Special parameter, see below for details. Usually set to 0 in the scripts.
-- Checkpoint types (prior to game build 2189):
-- 0-4---------Cylinder: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
-- 5-9---------Cylinder: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
-- 10-14-------Ring: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
-- 15-19-------1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
-- 20-24-------Cylinder: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
-- 25-29-------Cylinder: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
-- 30-34-------Cylinder: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
-- 35-38-------Ring: Airplane Up, Left, Right, UpsideDown
-- 39----------?
-- 40----------Ring: just a ring
-- 41----------?
-- 42-44-------Cylinder w/ number (uses 'reserved' parameter)
-- 45-47-------Cylinder no arrow or number
-- If using type 42-44, reserved sets number / number and shape to display
-- 0-99------------Just numbers (0-99)
-- 100-109-----------------Arrow (0-9)
-- 110-119------------Two arrows (0-9)
-- 120-129----------Three arrows (0-9)
-- 130-139----------------Circle (0-9)
-- 140-149------------CycleArrow (0-9)
-- 150-159----------------Circle (0-9)
-- 160-169----Circle  w/ pointer (0-9)
-- 170-179-------Perforated ring (0-9)
-- 180-189----------------Sphere (0-9)
-- ```
-- [Checkpoint Types](https://docs.fivem.net/docs/game-references/checkpoints/) as of game build 2189
function Global.CreateCheckpoint(type, posX1, posY1, posZ1, posX2, posY2, posZ2, diameter, red, green, blue, alpha, reserved)
	return _in2(fn, type, posX1, posY1, posZ1, posX2, posY2, posZ2, diameter, red, green, blue, alpha, reserved, _ri)
end
