local fn = _gn(0x65287525D951F6BE)
--- Returns the result of a shape test, also returning the material of any touched surface.
-- When used with an asynchronous shape test, this native should be looped until returning 0 or 2, after which the handle is invalidated.
-- Unless the return value is 2, the other return values are undefined.
-- @param shapeTestHandle A shape test handle.
-- @param hit Whether or not the shape test hit any collisions.
-- @param endCoords The resulting coordinates where the shape test hit a collision.
-- @param surfaceNormal The surface normal of the hit position.
-- @param materialHash hash of the hit material or surface type, see materialFX.dat
-- @param entityHit Any dynamic entity hit by the shape test.
-- @return `0` if the handle is invalid, `1` if the shape test is still pending, or `2` if the shape test has completed, and the handle should be invalidated.
function Global.GetShapeTestResultIncludingMaterial(shapeTestHandle)
	return _in2(fn, shapeTestHandle, _i --[[ actually bool ]], _v, _v, _i, _i, _ri)
end
